package gov.va.vamf.service.shifttransition.application.repositories;

import com.mongodb.*;
import gov.va.vamf.service.shifttransition.completedtasks.CompletedTasksRepository;
import gov.va.vamf.service.shifttransition.infrastructure.mongo.MongoWrapper;
import gov.va.vamf.service.shifttransition.tasks.PatientTasksRepository;
import gov.va.vamf.service.shifttransition.watchlist.MyPatientsRepository;
import org.slf4j.*;

/**
 * Used to make sure indexes exists within the mongodb.  Indexes are based on query needs found in the
 * various repository classes.
 */
public class Indexes {
    private static Logger logger = LoggerFactory.getLogger(Indexes.class);
    private MongoWrapper wrapper = new MongoWrapper();

    public void ensureIndexes() {
        addCompletedTasksIndexes();
        addPatientTasksIndexes();
        addMyPatientsIndexes();
    }

    private void addCompletedTasksIndexes() {
        try {
            DBCollection dbCollection = wrapper.getCollection(CompletedTasksRepository.COLLECTION_NAME).getDBCollection();

            BasicDBObject compoundIndex = createAscendingIndex("patientId", "siteId", "dateCompleted");

            dbCollection.ensureIndex(compoundIndex, "completed_task_index");

            compoundIndex = createAscendingIndex("taskId");
            compoundIndex.put("dateCompleted", -1);

            dbCollection.ensureIndex(compoundIndex, "last_completed_task_index");
        } catch (Exception e) {
            handlerException(e);
        }
    }

    private void addPatientTasksIndexes() {
        try {
            DBCollection dbCollection = getDbCollection(PatientTasksRepository.COLLECTION_NAME);

            BasicDBObject compoundIndex = createAscendingIndex("patientId", "siteId");

            dbCollection.ensureIndex(compoundIndex, "patient_tasks_index");
            dbCollection.ensureIndex(new BasicDBObject("tasks.id", 1), "task_index", true);
        } catch (Exception e) {
            handlerException(e);
        }
    }

    private void addMyPatientsIndexes() {
        try {
            BasicDBObject compoundIndex = createAscendingIndex("staffId", "siteId");

            getDbCollection(MyPatientsRepository.COLLECTION_NAME).ensureIndex(compoundIndex, "my_patient_list_index", true);
        } catch (Exception e) {
            handlerException(e);
        }
    }

    private DBCollection getDbCollection(String collectionName) {
        return wrapper.getCollection(collectionName).getDBCollection();
    }

    private BasicDBObject createAscendingIndex(String... fields) {
        BasicDBObject compoundIndex = new BasicDBObject();

        for (String field : fields) {
            compoundIndex.put(field, 1);
        }

        return compoundIndex;
    }

    private void handlerException(Exception ex) {
        MongoWrapper.closeConnection();
        logger.error("There was an error apply an index. This must be handled ASAP.", ex);
    }
}
