package gov.va.vamf.service.shifttransition.application.config;

import org.aeonbits.owner.Config;

/**
 * Service configuration.
 */
@Config.LoadPolicy(Config.LoadType.MERGE)
@Config.Sources({ "classpath:shift-transition/properties/ShiftTransitionConfig.properties",
                  "classpath:ShiftTransitionConfig.properties"})
public interface ShiftTransitionConfig extends Config {
    @Key("shift.transition.db.hosts")
    @Separator(";")
    @DefaultValue("localhost:PORT")
    Host[] hosts();

    @Key("shift.transition.db.auth.username")
    String userName();

    @Key("shift.transition.db.auth.pwd")
    String pwd();

    @Key("shift.transition.patient.base.url")
    String patientSearchBaseUrl();

    @Key("shift.transition.patient.connection.timeout")
    Integer patientConnectionTimeout();

    @Key("shift.transition.patient.read.timeout")
    Integer patientReadTimeout();
}


