package gov.va.vamf.service.shifttransition.application.config;

import com.google.common.primitives.Ints;

/**
 * Supports a single host or replica set (i.e. multiple instances of this class).
 */
public class Host {
    public Host(String hostPortPair) {
        String[] hostPort = hostPortPair.split(":");

        if (hostPort.length < 2 || Ints.tryParse(hostPort[1]) == null)
            throw new RuntimeException("Unable to parse host configuration from configuration file.  Format should be host:port.");

        name = hostPort[0];
        port = Integer.parseInt(hostPort[1]);
    }

    public String name;
    public int port;
}
