package gov.va.vamf.service.shifttransition.watchlist;

import static org.junit.Assert.assertEquals;

import gov.va.vamf.service.shifttransition.RepositoryTests;
import gov.va.vamf.service.shifttransition.application.repositories.RepositoryFactory;
import gov.va.vamf.service.shifttransition.infrastructure.mongo.MongoWrapper;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import java.util.Date;

public class MyPatientRepositoryTests extends RepositoryTests {
    private RepositoryFactory factory = new RepositoryFactory();

    @Before
    public void init() {
        saveMyPatients("42", "51");
    }

    @After
    public void cleanup() {
    	MongoWrapper mongo = new MongoWrapper();
    	mongo.getCollection(MyPatientsRepository.COLLECTION_NAME).remove();
    }

    @Test
    public void getNewMyPatientList() {
        MyPatientsRepository repository = factory.getMyPatientsRepository();
        MyPatients myPatients = repository.get("10", "51");

        PatientList patientList = myPatients.asPatientList();

        assertEquals("10", patientList.nurse.uniqueId);
        assertEquals("51", patientList.nurse.assigningAuthority);
        assertEquals(0, patientList.patients.size());
    }

    @Test
    public void getExistingMyPatientList() {
        MyPatientsRepository repository = factory.getMyPatientsRepository();
        MyPatients myPatients = repository.get("42", "51");

        PatientList patientList = myPatients.asPatientList();

        assertEquals("42", patientList.nurse.uniqueId);
        assertEquals("51", patientList.nurse.assigningAuthority);
        assertEquals(2, patientList.patients.size());
    }

    @Test
    public void removePatientsFromMyList() {
        MyPatientsRepository repository = factory.getMyPatientsRepository();
        MyPatients myPatients = repository.get("42", "51");

        myPatients.remove("1970");
        myPatients.remove("1972");

        repository.save(myPatients);

        myPatients = repository.get("42", "51");
        PatientList patientList = myPatients.asPatientList();

        assertEquals(0, patientList.patients.size());
    }

    @Test
    public void removePatientFromWatchList() {
        MyPatientsRepository repository = factory.getMyPatientsRepository();

        //Add a couple more users at a different site for this test
        saveMyPatients("42", "52");
        saveMyPatients("41", "52");

        repository.removePatientFromAllWatchList("51", "1970");
        repository.removePatientFromAllWatchList("52", "1972");

        PatientList patientList = repository.get("42", "51").asPatientList();
        assertEquals(1, patientList.patients.size());
        assertEquals("1972", patientList.patients.get(0).identity.uniqueId);

        patientList = repository.get("42", "52").asPatientList();
        assertEquals(1, patientList.patients.size());
        assertEquals("1970", patientList.patients.get(0).identity.uniqueId);

        patientList = repository.get("41", "52").asPatientList();
        assertEquals(1, patientList.patients.size());
        assertEquals("1970", patientList.patients.get(0).identity.uniqueId);
    }

    private void saveMyPatients(String staffId, String siteId) {
        MyPatients myPatients = new MyPatients(staffId, siteId);
        myPatients.add(createPerson(siteId, "1970"));
        myPatients.add(createPerson(siteId, "1972"));

        MyPatientsRepository repository = factory.getMyPatientsRepository();
        repository.save(myPatients);
    }

    private Person createPerson(String siteId, String uniqueId) {
        Person person = new Person();
        person.identity = new PersonIdentity(siteId, uniqueId);
        person.name = new Name("PII", "PII", "r");
        person.dob = new Date();
        person.gender = "M";

        return person;
    }
}