package gov.va.vamf.service.shifttransition.watchlist;

import static com.jayway.restassured.RestAssured.baseURI;
import static com.jayway.restassured.RestAssured.port;
import static org.hamcrest.Matchers.hasItems;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertEquals;

import com.jayway.restassured.http.ContentType;
import gov.va.vamf.service.shifttransition.ResourceTests;

import java.net.UnknownHostException;
import java.util.*;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.jayway.restassured.response.Response;

public class MyPatientListTests extends ResourceTests {

    private static String MY_PATIENT_LIST_BASE_URI = "/NursingShiftCompanionResources/rest/v1/nsc-service/facility/52/my-patient-list/42";

    @Before
    public void init() {
        getRequestSpecWithBearerToken()
                .body("{\"identity\": {\"assigningAuthority\": \"52\", \"uniqueId\": \"1970\"}, \"name\": {\"last\": \"skywalker\", \"first\": \"luke\"}, \"gender\": \"M\", \"dob\": " + new Date().getTime() + "}").when()
                .contentType(ContentType.JSON).when()
                .post(MY_PATIENT_LIST_BASE_URI)
                .then()
                .statusCode(200);

        getRequestSpecWithBearerToken()
                .body("{\"identity\": {\"assigningAuthority\": \"52\", \"uniqueId\": \"1972\"}, \"name\": {\"last\": \"smith\", \"first\": \"bob\"}, \"gender\": \"M\", \"dob\": " + new Date().getTime() + "}").when()
                .contentType(ContentType.JSON).when()
                .post(MY_PATIENT_LIST_BASE_URI)
                .then()
                .statusCode(200);
    }

    @After
    public void cleanUp() throws UnknownHostException {
        clearCollection(MyPatientsRepository.COLLECTION_NAME);
    }

    @Test
    public void addExistingPatientNotAllowed() {
        getRequestSpecWithBearerToken()
                .body("{\"identity\": {\"assigningAuthority\": \"52\", \"uniqueId\": \"1970\"}, \"name\": {\"last\": \"skywalker\", \"first\": \"luke\"}, \"gender\": \"M\", \"dob\": " + new Date().getTime() + "}").when()
                .contentType(ContentType.JSON).when()
                .post(MY_PATIENT_LIST_BASE_URI)
                .then()
                .statusCode(400);
    }

    @Test
    public void removePatient() {
        getRequestSpecWithBearerToken()
                .when()
                .delete(MY_PATIENT_LIST_BASE_URI + "/patients/1970")
                .then()
                .statusCode(200);

        getRequestSpecWithBearerToken()
                .when()
                .get(MY_PATIENT_LIST_BASE_URI)
                .then()
                .body("nurse.uniqueId", is("42"))
                .body("nurse.assigningAuthority", is("52"))
                .body("patients.size()", is(1))
                .body("patients.identity.uniqueId", hasItems("1972"));
    }

    @SuppressWarnings("rawtypes")
	@Test
    public void getMyPatientList() {
        Response response = getRequestSpecWithBearerToken()
                .when()
                .get(MY_PATIENT_LIST_BASE_URI)
                .then()
                .body("nurse.uniqueId", is("42"))
                .body("nurse.assigningAuthority", is("52"))
                .body("patients.size()", is(2))
                .body("patients.identity.uniqueId", hasItems("1972", "1970"))
                .extract().response();

        ArrayList links = response.path("link");
        assertEquals(4, links.size());

        String basePath = baseURI + ":" + port + MY_PATIENT_LIST_BASE_URI;

        verifyLink(links.get(0), "my-list", basePath);
        verifyLink(links.get(1), "add-patient-my-list", basePath);
        verifyLink(links.get(2), "patients-tasks-status", basePath + "/patients/tasks/status");
        verifyLink(links.get(3), "patients-tasks", basePath + "/patients/tasks");
    }
 }
