package gov.va.vamf.service.shifttransition.userpreferences;

import gov.va.vamf.service.shifttransition.application.config.ShiftTransitionConfig;
import gov.va.vamf.service.shifttransition.ResourceTests;
import gov.va.vamf.service.shifttransition.infrastructure.mongo.MongoWrapper;

import java.net.UnknownHostException;

import org.aeonbits.owner.ConfigFactory;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Test;

import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;

public class UserPreferencesResourceTests extends ResourceTests {
	private static String BASE_URI = "/NursingShiftCompanionResources/rest/v1/nsc-service/facility/TEST_FACILITY/user/TEST_USER/shift-interval";

	@After
	public void cleanup() throws UnknownHostException {
		clearCollection(UserPreferencesRepository.COLLECTION_NAME);
	}
	
	protected void clearCollection(String collectionName) throws UnknownHostException {
		ShiftTransitionConfig config = ConfigFactory.create(ShiftTransitionConfig.class, System.getProperties());
		MongoWrapper.initializeConnection(config);
		
		MongoWrapper mongo = new MongoWrapper();
		mongo.getCollection(collectionName).remove("{\"siteId\":\"TEST_FACILITY\",\"staffId\":\"TEST_USER\"}");
	}

	@Test
	public void getPutGetPostGet() {
		long startDate = createDateWithOffset(4000000);
		long endDate = createDateWithOffset(12000000);
		long newStartDate = createDateWithOffset(3000000);
		long newEndDate = createDateWithOffset(11000000);

		//Nothing should be returned for startDate and endDate
		getRequestSpecWithBearerToken()
			.when()
			.get(BASE_URI)
			.then()
			.body("startDate", Matchers.nullValue())
			.body("endDate", Matchers.nullValue());

		//Save startDate and endDate
		Response response = getRequestSpecWithBearerToken()
			.body("{\"siteId\":\"TEST_FACILITY\",\"staffId\":\"TEST_USER\", \"startDate\" : \"" + startDate + "\", \"endDate\" : \"" + endDate + "\"}").with()
			.contentType(ContentType.JSON).when()
			.post(BASE_URI)
			.then()
			.statusCode(200)
			.body("_id", Matchers.notNullValue())
			.extract().response();
		
		String json = response.asString();
		JsonPath jsonPath = new JsonPath(json);
        String _id = jsonPath.getString("_id");
		
		//Verify our save happened.
		getRequestSpecWithBearerToken()
			.when()
			.get(BASE_URI)
			.then()
			.statusCode(200)
			.body("startDate", Matchers.is(startDate))
			.body("endDate", Matchers.is(endDate))
			.body("_id", Matchers.is(_id));
		
		//Save newStartDate and newEndDate
		getRequestSpecWithBearerToken()
			.body("{\"_id\" : \"" + _id + "\", \"siteId\":\"TEST_FACILITY\",\"staffId\":\"TEST_USER\", \"startDate\" : \"" + newStartDate + "\", \"endDate\" : \"" + newEndDate + "\"}").with()
			.contentType(ContentType.JSON).when()
			.put(BASE_URI)
			.then()
			.statusCode(200);
		
		//Verify our save happened.
		getRequestSpecWithBearerToken()
			.when()
			.get(BASE_URI)
			.then()
			.statusCode(200)
			.body("startDate", Matchers.is(newStartDate))
			.body("endDate", Matchers.is(newEndDate))
			.body("_id", Matchers.is(_id));
	}
}
