package gov.va.vamf.service.shifttransition.tasks;

import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.response.Response;
import gov.va.vamf.service.shifttransition.ResourceTests;
import org.junit.*;

import java.net.UnknownHostException;
import java.util.Date;

import static org.hamcrest.Matchers.is;

public class TaskTests extends ResourceTests {
    private static String PATIENT_BASE_URI = "/NursingShiftCompanionResources/rest/v1/nsc-service/facility/52/patients/1970";

    @Before
    public void init() {
        getRequestSpecWithBearerToken()
                .body("{\"name\": \"Bowling\", \"type\" : \"Custom\", \"startDate\" : \"" + new Date().getTime() + "\"}").with()
                .contentType(ContentType.JSON).when()
                .post(PATIENT_BASE_URI + "/tasks")
                .then()
                .statusCode(200);
    }

    @After
    public void cleanup() throws UnknownHostException {
        clearCollection(PatientTasksRepository.COLLECTION_NAME);
    }

    @Test
    public void updateExisting() {
        Response response = getRequestSpecWithBearerToken()
                .when()
                .queryParam("start-date", createDateWithOffset(-2000000))
                .queryParam("end-date", createDateWithOffset(2000000))
                .get(PATIENT_BASE_URI + "/tasks")
                .then()
                .extract().response();

        String taskId = response.path("tasks.get(0).taskId");

        long newStartDate = createDateWithOffset(4000000);

        getRequestSpecWithBearerToken()
                .body("{\"startDate\" : \"" + newStartDate + "\"}").with()
                .contentType(ContentType.JSON).when()
                .put(PATIENT_BASE_URI + "/tasks/" + taskId)
                .then()
                .statusCode(200);

        getRequestSpecWithBearerToken()
                .when()
                .get(PATIENT_BASE_URI + "/tasks/" + taskId)
                .then()
                .body("startDate", is(newStartDate));
    }

    @Test
    public void taskNotFoundForUpdate() {
        getRequestSpecWithBearerToken()
                .body("{\"startDate\" : \"" + new Date().getTime() + "\"}").with()
                .contentType(ContentType.JSON).when()
                .put(PATIENT_BASE_URI + "/tasks/123")
                .then()
                .statusCode(404);
    }
}
