package gov.va.vamf.service.shifttransition.infrastructure.patientsearch;

import gov.va.vamf.service.shifttransition.application.config.*;
import gov.va.vamf.service.shifttransition.ResourceTests;
import org.junit.*;

import static org.junit.Assert.*;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

public class InvalidInpatientResourceTest extends ResourceTests {
    private ShiftTransitionConfig config;

    @Before
    public void initConfig() {
        config = mock(ShiftTransitionConfig.class);
    }

    @Test
    public void invalidTokenProvided() {
        when(config.patientSearchBaseUrl()).thenReturn(ResourceTests.HOST_URI + "/PatientViewerServices/rest/patient");
        InpatientResource inpatientResource = new InpatientResource(config);

        boolean found = inpatientResource.patientStillAtFacility("777", "100718", "1");

        assertTrue(found);
    }

    @Test
    public void invalidPatientUrlUsed() {
        when(config.patientSearchBaseUrl()).thenReturn(ResourceTests.HOST_URI + "/PatientViewerServices/NOrest/patient");
        InpatientResource inpatientResource = new InpatientResource(config);

        boolean found = inpatientResource.patientStillAtFacility("777", "100718", getBearTokenToken());

        assertTrue(found);
    }
}
