package gov.va.vamf.service.shifttransition.infrastructure.patientsearch;

import gov.va.vamf.service.shifttransition.application.config.*;
import gov.va.vamf.service.shifttransition.ResourceTests;
import org.junit.*;

import static junit.framework.TestCase.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.*;

public class InpatientResourceTests extends ResourceTests {
    private InpatientResource inpatientResource;

    @Before
    public void init() {
        ShiftTransitionConfig config = mock(ShiftTransitionConfig.class);
        when(config.patientSearchBaseUrl()).thenReturn(ResourceTests.HOST_URI + "/PatientViewerServices/rest/patient");

        inpatientResource = new InpatientResource(config);
    }

    @Test
    public void patientFoundButNotInWard() {
        assertFalse(inpatientResource.patientStillAtFacility("777", "100617", getBearTokenToken()));
    }

    @Test
    public void patientFoundInWard() {
        assertTrue(inpatientResource.patientStillAtFacility("777", "100718", getBearTokenToken()));
    }

    @Test
    public void patientNotFound() {
        assertFalse(inpatientResource.patientStillAtFacility("777", "1", getBearTokenToken()));
    }
}
