package gov.va.vamf.service.shifttransition.completedtasks;

import com.jayway.restassured.http.ContentType;
import gov.va.vamf.service.shifttransition.ResourceTests;
import org.junit.*;

import java.net.UnknownHostException;
import java.util.Date;

import static org.hamcrest.Matchers.*;

public class CompletedTasksTests extends ResourceTests {
    private static final String TASK_ID = "123";
    private static String COMPLETED_TASKS_BASE_URI = "/NursingShiftCompanionResources/rest/v1/nsc-service/facility/52/patients/1970";

    @Before
    public void init() {
        getRequestSpecWithBearerToken()
                .body("{\"taskName\": \"Bowling\", \"status\" : \"Completed\"}").with().contentType(ContentType.JSON).when()
                .post(COMPLETED_TASKS_BASE_URI + "/completedTasks/" + TASK_ID)
                .then()
                .statusCode(200);

        getRequestSpecWithBearerToken()
                .body("{\"taskName\": \"Bowling\", \"status\" : \"Dismissed\", \"comment\" : \"Gutter ball.\"}")
                .with().contentType(ContentType.JSON).when()
                .post(COMPLETED_TASKS_BASE_URI + "/completedTasks/" + TASK_ID)
                .then()
                .statusCode(200);
    }
    @After
    public void cleanUp() throws UnknownHostException {
        clearCollection(CompletedTasksRepository.COLLECTION_NAME);
    }

    @Test
    public void addWithInvalidCompletedStatus() {
        getRequestSpecWithBearerToken()
                .body("{\"taskName\": \"Bowling\", \"status\" : \"Pending\"}").with().contentType(ContentType.JSON).when()
                .post(COMPLETED_TASKS_BASE_URI + "/completedTasks/" + TASK_ID)
                .then()
                .statusCode(400);
    }

    @Test
    public void addWithoutTaskName() {
        getRequestSpecWithBearerToken()
                .body("{\"status\" : \"Completed\"}").with().contentType(ContentType.JSON).when()
                .post(COMPLETED_TASKS_BASE_URI + "/completedTasks/" + TASK_ID)
                .then()
                .statusCode(400);

    }

    @Test
    public void getCompletedTasks() {
        getRequestSpecWithBearerToken()
                .when()
                .queryParam("start-date", new Date(0))
                .queryParam("end-date", new Date(Long.MAX_VALUE))
                .get(COMPLETED_TASKS_BASE_URI + "/completedTasks")
                .then()
                .body("$.size()", is(1))
                .body("get(0).patientId", is("1970"))
                .body("get(0).siteId", is("52"))
                .body("get(0).taskId", is(TASK_ID))
                .body("get(0).completedBy", is("PROGRAMMER, ONE"))
                .body("get(0).dateCompleted", isA(Long.class))
                .body("get(0).status", is("Completed"))
                .body("get(0).taskName", is("Bowling"));
    }

    @Test
    public void getCompletedTasksOutsideRange() {
        getRequestSpecWithBearerToken()
                .when()
                .queryParam("start-date", new Date(0))
                .queryParam("end-date", new Date(100000))
                .get(COMPLETED_TASKS_BASE_URI + "/completedTasks")
                .then()
                .body("$.size()", is(0));
    }
}
