package gov.va.vamf.service.shifttransition;

import static com.jayway.restassured.RestAssured.given;
import static org.junit.Assert.assertEquals;
import gov.va.vamf.service.shifttransition.application.config.ShiftTransitionConfig;
import gov.va.vamf.service.shifttransition.infrastructure.mongo.MongoWrapper;

import java.net.UnknownHostException;
import java.util.Date;
import java.util.Map;

import org.aeonbits.owner.ConfigFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;

import com.agilex.healthcare.mobilehealthplatform.security.Client;
import com.agilex.healthcare.mobilehealthplatform.security.ClientIdentification;
import com.agilex.healthcare.mobilehealthplatform.security.User;
import com.agilex.healthcare.mobilehealthplatform.security.infrastructure.HttpClient;
import com.agilex.healthcare.mobilehealthplatform.security.infrastructure.Value;
import com.jayway.restassured.specification.RequestSpecification;

public class ResourceTests {
    //Should match base uris found in project's oauth.properties file.
    //public static final String HOST_URI = "https://hastafftest.agilexhealth.com";
    public static final String HOST_URI = "http://localhost:PORT";
    private static final String REDIRECT_URI = HOST_URI + "/launchpad/";
    private static final String STAFF_AUTHORIZE_BASE_URI = "/AuthorizationServices/provider";

    private static HttpClient httpClient;
    private static ClientIdentification clientIdentification;
    private static Client client;
    private static User user;

    private static Value accessToken;

    @BeforeClass
    public static void initSecurity() {
        //RestAssured.PORT       ;

        httpClient = new HttpClient(HOST_URI);
        clientIdentification = new ClientIdentification("MBBWEB", "MobileBlueButton", REDIRECT_URI);

        getAccessToken("cprs1234", "cprs4321$", "777", "TEST VAMC 3");
    }

    private static void getAccessToken(String userId, String pass, String facilityCode, String facilityName) {
        client = Client.createClient(httpClient, clientIdentification, STAFF_AUTHORIZE_BASE_URI);
        user = new User(httpClient, userId, pass, facilityCode, facilityName, STAFF_AUTHORIZE_BASE_URI);

        getAccessToken();
    }

    private static void getAccessToken() {
        Value code = client.authorize(user);
        accessToken = client.getAccessToken(code);
    }

    @AfterClass
    public static void closeSecurityConnection() {
        client.logoutAndCloseConnection(user, accessToken);
    }

    protected RequestSpecification getRequestSpecWithBearerToken() {
        return given().header("Authorization", getBearTokenToken());
    }

    protected String getBearTokenToken() {
        return "Bearer " + accessToken.toString();
    }

    protected void clearCollection(String collectionName) throws UnknownHostException {
    	ShiftTransitionConfig config = ConfigFactory.create(ShiftTransitionConfig.class, System.getProperties());
    	MongoWrapper.initializeConnection(config);
    	
    	MongoWrapper mongo = new MongoWrapper();
    	mongo.getCollection(collectionName).remove();
    }

    @SuppressWarnings("unchecked")
	protected void verifyLink(Object linkMap, String title, String href) {
        Map<String, String> link = (Map<String, String>) linkMap;
        assertEquals(title, link.get("title"));
        assertEquals(href, link.get("href"));
    }

    protected long createDateWithOffset(long offset) {
        return new Date(new Date().getTime() + offset).getTime();
    }
}
