package gov.va.vamf.service.shifttransition;

import gov.va.vamf.service.shifttransition.application.config.ShiftTransitionConfig;
import gov.va.vamf.service.shifttransition.infrastructure.mongo.MongoWrapper;

import java.net.UnknownHostException;

import org.aeonbits.owner.ConfigFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;

/**
 * Add a Description.  Should include class purpose (why not what) and assumptions.
 */
public abstract class RepositoryTests {
    public static final String DB_NAME = "shift_transition_registry";

    @BeforeClass
    public static void setupDB() throws UnknownHostException {
    	ShiftTransitionConfig config = ConfigFactory.create(ShiftTransitionConfig.class, System.getProperties());
        MongoWrapper.initializeConnection(config);
    }

    @AfterClass
    public static void closeDB() {
        MongoWrapper.closeConnection();
    }
}
