@echo off
REM clear build directory (delete the tar file previously generated) before ICD artifact generation
IF NOT EXIST "C:\Projects\nsc-resources\NursingShiftCompanionResources\build\icd" GOTO NOWORKAREA
rmdir /s /q "C:\Projects\nsc-resources\NursingShiftCompanionResources\build\icd"
:NOWORKAREA

REM This is the actual set of calls that generates the new icd.tar file.
set ENUNCIATE_HOME=C:\enunciate-1.28
cd "C:\Projects\nsc-resources\NursingShiftCompanionResources"
CALL gradlew clean build generateIcd -DuseEnunciate=true --info --stacktrace --debug > output.txt

REM clear 200+ MB from the temp directories after ICD artifact generation
echo Cleaning Up...
cd %TEMP%\
for /d %%a in (enunciate*) do rmdir /s /q %%a
del /q "%TEMP%\enunciate*"
cd "C:\Projects\nsc-resources\NursingShiftCompanionResources"

REM This checks to see if the tar file exists.
REM If the tar file does exist, it extracts it and launches Windows Explorer to that directory
IF NOT EXIST "C:\Projects\nsc-resources\NursingShiftCompanionResources\build\icd\icd.tar" GOTO EOF
"%ProgramFiles%\7-Zip\7z.exe" x build\icd\icd.tar -y -obuild\icd\icd | FIND "Everything is Ok"
start explorer.exe "C:\Projects\nsc-resources\NursingShiftCompanionResources\build\icd\icd"
echo .
echo .
echo .
echo Successful generation of artifacts will appear here:
echo build\icd\icd.tar
:EOF
@echo on