#$LOAD_PATH.unshift(File.join(File.dirname(__FILE__), '..', 'lib'))

require 'watir-webdriver'
require 'rspec'
require 'json'
require 'page-object'
require 'page-object/page_factory'

require_relative '../module/DriverUtility'
#require_relative '../lib/pages/eula'

RSpec.configure do |c|
  # declare an exclusion filter
  c.filter_run_excluding :broken => true
  c.filter_run_excluding :regression => true
  c.filter_run_excluding :acceptance => true
  c.filter_run_excluding :smoketest => true
end


RSpec.configure do |config|

	fetch_current_example = RSpec.respond_to?(:current_example) ? proc { RSpec.current_example } : proc { |context| context.example }

	config.include PageObject::PageFactory

	config.after(:each) do
		example = fetch_current_example.call(self);

		if example.exception
			meta = example.metadata
			filename = File.basename(meta[:file_path])
			line_number = meta[:line_number]
			#screenshot_name = "screenshot-#{filename}-#{line_number}.png"
			@time = Time.new
			tm = @time.inspect()
			screenshot_name = "screenshot-#{filename}-#{line_number}-#{tm}.png"

			screenshot_path = "failed_sm_tests_screenshots/#{screenshot_name}"
			@driver.save_screenshot(screenshot_path)
			puts "-----------Failed TestCase Screenshot -------------"
		end
	end
end

#BASE_URL = "http://localhost:8080/secure-messaging"
#BASE_URL = "https://hatest.agilexhealth.com/secure-messaging"
BASE_URL = "http://localhost:8080/launchpad"


