require "spec_helper"
require "./spec/spec_helper"
require "page-object"

class Search
	include PageObject

	text_field(:patient_search_field, :id => 'patient-list-filter')

	link(:patient_search_icon, :css => '#patient-search > a')
	link(:patient_search_tab, :href => '#search-patients')

	div(:search_div, :css => '#search')

	li(:patient_search_list_items, :css => '#patient-list li')

	button(:confirm_btn, :css => '#confirm-button')
	div(:patient_context, :id => 'patient-context')

	def openPageObject(driver)
		@driver = driver
		# @wait = Selenium::WebDriver::Wait.new(:timeout => 10)
		# @searchWait = Selenium::WebDriver::Wait.new(:timeout => 25)
	end

	def updatePatientContextByName(patientName)

		begin

		if (!patient_context_element.when_present(timeout = 30).text.downcase.start_with? patientName.downcase)
			patient_search_icon_element.click
			patient_search_tab_element.when_present.click
			patient_search_field_element.clear
			patient_search_field_element.value = patientName
			#puts "patient_search_field_element.value #{patient_search_field_element.value}"
			patient_search_field_element.send_keys :enter
			#puts "@driver.link(:text => patientName.upcase) #{@driver.link(:text => patientName.upcase)}"
			@driver.link(:text => patientName.upcase).when_present(timeout = 30).click
			#puts "@driver.div(:css => '#confirmation-popup').visible?"
			sleep 2
			#puts "confirm_btn_element visible #{confirm_btn_element.visible?}"
			confirm_btn_element.when_present(timeout = 30).click
		end

		rescue Exception => ex
			puts "exception message: #{ex.message}"
			puts "exception stacktrace:\n #{ex.backtrace.inspect}"
			@driver.screenshot.save 'patient_search_error_screenshot.png'
		end


		# patient_context_element.when_present.text.downcase.start_with? patientName.downcase
	end

end
