require_relative "_config"
require "page-object"

class ProviderLogin
	include PageObject

	text_field(:user, :id => 'name-c')
	text_field(:pass_word, :id => 'password')
	text_field(:facility_name, :id => 'va-hospital')

	button(:login_btn, :id => 'loginButton')
	div(:user_disclaimer, :id => 'portal-staff-user-disclaimer')
	button(:accept_btn, :id => 'accept-btn')

  def openPageObject(driver)
    @driver = driver
  end

  # def login (username, password, facility)
  #   wait = Selenium::WebDriver::Wait.new(:timeout => 80)
  #
  #   @driver.goto($acp_url + "/AuthorizationServices/logout")
  #
  #   @driver.goto($acp_url + "/" + $acp_app)
  #
  #   user_element.value = username
  #   pass_word_element.value = password
  #   facility_name_element.value = facility
  #
  #   sleep(3); #give time for autocomplete
  #   # wait.until{ @driver.find_element(:css, "a[data-facility-name='" + facility + "']").displayed? }
  #   # @driver.find_element(:css, "a[data-facility-name='" + facility + "']").click
  #   # @driver.find_element(:id, 'loginButton').click
  #   login_btn
  #
  #   #accept SUD if present
  #   !5.times{
  #     # if (element_present?(:id, "portal-staff-user-disclaimer"))
  #     #   @driver.find_element(:id, "accept-btn").click()
	# 	if (user_disclaimer_element.when_present.visible?)
	# 		accept_btn_element.when_present.click
  #           break
  #       end
  #     sleep 1
  #   }
  # end

  def loginHiddenFacility (username, password, facility)

    @driver.goto($acp_url + "/AuthorizationServices/logout")

    @driver.goto($acp_url + "/" + $acp_app)
	  # puts "current page title: #{@driver.title}"
	  # puts "current page html: #{@driver.html}"

    user_element.when_present(timeout = 10).value = username
    pass_word_element.value = password
    facility_name_element.value = facility

    facilityCode = ""
    case facility
      when "TEST VAMC"
        facilityCode = "500"
      when "DC VAMC"
        facilityCode = "688"
      when "TEST VAMC 3"
        facilityCode = "777"
    end

    @driver.execute_script("$('#facilityCode').val('" + facilityCode + "');$('#facilityName').val('" + facility.upcase + "');")

    login_btn

    #accept SUD if present
    begin
	    if (user_disclaimer_element.when_present(timeout = 20).visible?)
		    accept_btn_element.when_present.click
        puts "eula present, clicking on it"
	    end
    rescue
		 puts "eula not present"
    end
  end

  # def loginAsStaff01()
  #   login('zztest.staff01', 'pass', 'DC VAMC')
  # end

  def loginAsDoc123(site = 'TEST VAMC')
    loginHiddenFacility('doc123', 'doc123!!', 'DC VAMC')
  end

  def loginAsDoc123DC()
    loginHiddenFacility('doc123', 'doc123!!', 'DC VAMC')
  end

  # def loginAsScvtest2()
  #   login('zztest.scvtest2', 'pass', 'TEST VAMC 3')
  # end

  def loginAsCprs1234()
    loginHiddenFacility('cprs1234', 'cprs4321$', 'TEST VAMC 3')
  end
end

