require 'active_support/time'
require 'watir-webdriver'
require 'rspec'

module DriverUtility


  def initializeConfigurations(base_url)

    @driver = Watir::Browser.new :firefox
    @driver.cookies.clear
    @driver.goto(base_url)
    @driver.window.resize_to 1100, 850
    @driver.window.move_to 0,0
    #@driver.driver.manage.timeouts.implicit_wait = 3

	#@driver.get(base_url + "/")
	#@driver.manage().window().maximize()


	creatDir('./failed_sm_tests_screenshots')
=begin
    if !Dir.exists?("screenshots")
      Dir.mkdir "screenshots"
    end
=end

  end

  def gotoHome(baseUrl)
    @driver.goto(baseUrl + "/")
  end

  def getCurrentURL()
    return @driver.url
  end

  def quitDriver()
    @driver.quit
  end

  def resizeWindowTo(width, height)
    @driver.window.resize_to width, height
    sleep 0.5
  end

  def resizeWindowToDefault()
    resizeWindowTo(1260, 727)
    sleep 0.5
  end

  def switchWindowHandleToLatest()
    @driver.windows.last.use
  end

  def switchWindowHandleToPrevious()
    @driver.window(:index => 0).use
  end

  def parse(val)
    return JSON.parse(val)
  end

  def getVersionFromVersionFile()
    versionJsonPath = File.dirname(__FILE__) + "/../../../../dist/version.json"
    #puts versionJsonPath

    jsonfile = File.open(versionJsonPath).read
    versionJson= parse(jsonfile.to_s())

    #puts 'version json:  ' +versionJson.to_s()
    return ('v' + versionJson['version'] )

  end

  def creatDir(dirPath)
=begin
		if File.exists?(dirPath)
			FileUtils.rm_r(dirPath)
		end
		Dir.mkdir(dirPath)
=end
	  ## If you want to keep old screenshots
	  if !Dir.exists?(dirPath)
		  Dir.mkdir(dirPath)
	  end

  end


end