'use strict';

var grunt,
	setGrunt = function (g) {
		grunt = g;
	},
	createRequireJSDependencyModulesAndFetchList = function () {
		if (!grunt) {
			console.log('setGrunt before calling this method');
			return;
		}

		var ViewModes = {
			STAFF_VIEW_MODE: 'staff-view',
			PATIENT_VIEW_MODE: 'patient-view'
		};

		var appConfig = grunt.file.readJSON('appConfig.json'),
			i,
			appletName,
			appletVersion,
			appletPath,
			excludeList = ['Portal', 'backbone', 'marionette', 'jquery', 'underscore', 'jquerymobile', 'hbs', 'json2', 'i18nprecompile'],
			applets,
			appletListLength,
			excludeShallowList = [],
			fetchList = [],
			dynamicallyLoadedModules = [];

		var patientViewApplets;
		var patientViewAppletHelpers;
		var staffViewApplets;
		var staffViewAppletHelpers = [];

		if (appConfig[ViewModes.PATIENT_VIEW_MODE]) {
			patientViewApplets = appConfig[ViewModes.PATIENT_VIEW_MODE].navigation || [];
			patientViewAppletHelpers = appConfig[ViewModes.PATIENT_VIEW_MODE].helpers || [];
		}
		if (appConfig[ViewModes.STAFF_VIEW_MODE]) {
			staffViewApplets = appConfig[ViewModes.STAFF_VIEW_MODE].navigation || [];
			staffViewAppletHelpers = appConfig[ViewModes.STAFF_VIEW_MODE].helpers || [];
		}

		applets = patientViewApplets.concat(patientViewAppletHelpers, staffViewApplets, staffViewAppletHelpers);
		applets = applets.filter(function (item, pos) { //filter out duplicates based on applet name
			for(var i = 0; i < applets.length; i++){
				if(applets[i].name === item.name){
					return applets[i] == item;
				}
			}
		});

		appletListLength = applets.length;
		// dynamically create require js modules and dependency fetch list based on applets defined in package.json
		for (i = 0; i < appletListLength; i += 1) {
			appletName = applets[i].name;
			appletVersion = applets[i].version;
			appletPath = "applets/" + appletName + "/loader";

			excludeShallowList.push(appletPath);

			dynamicallyLoadedModules.push({
				name: appletPath,
				exclude: excludeList
			});

			fetchList.push({
				id: 'com.agilex.healthcare.portal.js:' + appletName + ':tgz:' + appletVersion,
				path: 'container/applets/' + appletName
			});
		}

		// add init require js module
		dynamicallyLoadedModules.unshift({
			//name: "core/init",
			name: "config",
			excludeShallow: excludeShallowList
		});

		// add portal container dependency
		fetchList.unshift({
			id: 'com.agilex.healthcare.portal.js:applet-container:tgz:' + appConfig["applet-container"].version,
			path: 'container/'
		});

		return {
			dynamicallyLoadedModules: dynamicallyLoadedModules,
			fetchList: fetchList
		}
	};

module.exports = {
	setGrunt: setGrunt,
	createRequireJSDependencyModulesAndFetchList: createRequireJSDependencyModulesAndFetchList
};
