package gov.va.vamf.service.clio.observation.validation;

import com.google.common.collect.Lists;
import gov.va.vamf.service.clio.application.representations.UniqueTermId;
import gov.va.vamf.service.clio.flowsheet.representations.Field;
import gov.va.vamf.service.clio.observation.ObservationException;
import gov.va.vamf.service.clio.observation.representations.*;
import org.junit.Test;

import java.util.List;

public class ObservationValidatorTests {

    @Test(expected = ObservationException.class)
    public void observationNotFoundInFlowsheet() {
        List<Field> fields = Lists.newArrayList();

        Field field = new Field();
        field.uniqueTermId = new UniqueTermId("1", "ONE");

        fields.add(field);

        Observation observation = new Observation();
        observation.uniqueTermId = new UniqueTermId("2" ,"TWO");

        Validator validator = new ObservationValidator(observation, fields);
        validator.validate();
    }
}
