package gov.va.vamf.service.clio.observation.validation;

import com.google.common.collect.Lists;
import gov.va.vamf.service.clio.application.representations.UniqueTermId;
import gov.va.vamf.service.clio.flowsheet.representations.*;
import gov.va.vamf.service.clio.observation.representations.Observation;
import org.junit.*;

import static org.junit.Assert.fail;

public class ObservationHasValidQualifierTermsTests {
    private Field field;
    private Observation observation;

    private Validator validator;

    @Before
    public void init() {
        field = new Field();

        Field unitQualifier = new Field();
        unitQualifier.possibleValues.add(new Value(new UniqueTermId("1", "ONE")));
        unitQualifier.possibleValues.add(new Value(new UniqueTermId("2", "TWO")));

        Field methodQualifier = new Field();
        methodQualifier.possibleValues.add(new Value(new UniqueTermId("3", "THREE")));
        methodQualifier.possibleValues.add(new Value(new UniqueTermId("4", "FOUR")));

        field.qualifiers.add(unitQualifier);
        field.qualifiers.add(methodQualifier);

        observation = new Observation();
        observation.qualifierIds = Lists.newArrayList();
        observation.qualifierIds.add(new UniqueTermId("2", "TWO"));
        observation.qualifierIds.add(new UniqueTermId("3", "THREE"));

        validator = new ObservationHasValidQualifierTerms(field, observation);
    }

    @Test
    public void hasValidQualifiers() {
        try {
            validator.validate();
        } catch (Throwable t) {
            fail("Validator failed.");
        }
    }

    @Test(expected = IllegalArgumentException.class)
    public void hasInvalidQualifiers() {
        observation.qualifierIds.add(new UniqueTermId("5", "FIVE"));

        validator.validate();
    }

    @Test
    public void observationHasNoQualifiers() {
        observation.qualifierIds = null;

        try {
            validator.validate();
        } catch (Throwable t) {
            fail("Validator failed.");
        }
    }

    @Test(expected = IllegalArgumentException.class)
    public void fieldHasNoQualifiers() {
        field.qualifiers.clear();

        validator.validate();
    }
}

