package gov.va.vamf.service.clio.observation.validation;

import com.google.common.collect.Lists;
import gov.va.vamf.service.clio.application.representations.UniqueTermId;
import gov.va.vamf.service.clio.flowsheet.representations.*;
import gov.va.vamf.service.clio.observation.ObservationException;
import gov.va.vamf.service.clio.observation.representations.Observation;
import org.junit.*;

import static org.junit.Assert.fail;

/**
 * Add a Description.  Should include class purpose (why not what) and assumptions.
 */
public class ObservationHasRequiredQualifierTermsTests {
    private Field field;
    private Observation observation;

    private Validator validator;

    @Before()
    public void init() {
        field = new Field();
        field.required = true;
        field.uniqueTermId = new UniqueTermId("2", "TWO");

        Field qualifier = new Field();
        qualifier.uniqueTermId = new UniqueTermId("3", "THREE");
        qualifier.defaultValueId = new UniqueTermId("4", "FOUR");

        field.qualifiers.add(qualifier);

        observation = new Observation();

        validator = new ObservationHasRequiredQualifierTerms(field, observation);
    }

    @Test
    public void observationIncludesAllRequiredQualifiers() {
        observation.qualifierIds = Lists.newArrayList();
        observation.qualifierIds.add(new UniqueTermId("4", "FOUR"));

        try {
            validator.validate();
        } catch (Exception e) {
            fail("All required qualifiers should be part of the observation.");
        }

    }

    @Test(expected = IllegalArgumentException.class)
    public void observationMissingRequiredQualifier() {
        observation.qualifierIds = Lists.newArrayList();
        observation.qualifierIds.add(new UniqueTermId("6", "SIX"));

        validator.validate();
    }

    @Test(expected = IllegalArgumentException.class)
    public void observationWithNullQualifiers() {
        validator.validate();
    }

    @Test(expected = IllegalArgumentException.class)
    public void observationZeroQualifiers() {
        observation.qualifierIds = Lists.newArrayList();
        validator.validate();
    }

    @Test
    public void observationWithDefaultButFieldNotRequired() {
        field.required = false;
        observation.qualifierIds = Lists.newArrayList();
        observation.qualifierIds.add(new UniqueTermId("4", "FOUR"));

        try {
            validator.validate();
        } catch (Exception e) {
            fail("Field should be required for this to fail.");
        }

    }

}
