package gov.va.vamf.service.clio.observation.validation;

import com.google.common.collect.Lists;
import gov.va.vamf.service.clio.application.representations.UniqueTermId;
import gov.va.vamf.service.clio.flowsheet.representations.*;
import gov.va.vamf.service.clio.observation.ObservationException;
import gov.va.vamf.service.clio.observation.representations.Observation;
import org.junit.*;

import java.util.List;

import static org.junit.Assert.fail;

public class ObsSetIncludeAllRequiredFieldsTests {
    private List<Field> fields;
    private List<Observation> observations;

    private Validator validator;

    @Before()
    public void init() {
        fields = Lists.newArrayList();

        Field field = new Field();
        field.uniqueTermId = new UniqueTermId("1", "ONE");
        field.required = true;

        fields.add(field);

        field = new Field();
        field.uniqueTermId = new UniqueTermId("2", "TWO");

        fields.add(field);

        observations = Lists.newArrayList();

        validator = new ObsSetIncludeAllRequiredFields(fields, observations);
    }

    @Test
    public void observationSetIncludesAllRequiredFields() {
        Observation observation = new Observation();
        observation.uniqueTermId = new UniqueTermId("1", "ONE");

        observations.add(observation);

        try {
            validator.validate();
        } catch (Exception e) {
            fail("All required fields are part of the observation.");
        }
    }

    @Test(expected = ObservationException.class)
    public void observationSetMissingRequiredField() {
        Observation observation = new Observation();
        observation.uniqueTermId = new UniqueTermId("2", "Two");

        observations.add(observation);

        validator.validate();
    }

    //Multi picklist
    @Test
    public void observationSetWithSameObservation() {
        Observation observation = new Observation();
        observation.uniqueTermId = new UniqueTermId("1" ,"ONE");

        observations.add(observation);

        observation = new Observation();
        observation.uniqueTermId = new UniqueTermId("1" ,"ONE");

        observations.add(observation);

        try {
            validator.validate();
        } catch (Exception e) {
            fail("Should be ok to have the same observation in the set multiple times.");
        }
    }

}
