package gov.va.vamf.service.clio.observation.validation;

import gov.va.vamf.service.clio.application.representations.*;
import gov.va.vamf.service.clio.flowsheet.representations.Flowsheet;
import gov.va.vamf.service.clio.observation.ObservationException;
import gov.va.vamf.service.clio.observation.representations.ObservationSet;
import org.junit.*;

import static org.junit.Assert.fail;

public class LocationValidatorTests {
    private Flowsheet flowsheet;
    private ObservationSet observationSet;

    private Validator validator;

    @Before
    public void init() {
        flowsheet = new Flowsheet();
        flowsheet.uniqueTermId = new UniqueTermId("abc", "FL");

        Location location = new Location();
        location.name = "Here";
        location.id = 1;

        flowsheet.possibleLocations.add(location);

        observationSet = new ObservationSet();

        location = new Location();
        location.name = "Here";
        location.id = 1;

        observationSet.location = location;

        validator = new LocationValidator(flowsheet, observationSet);
    }

    @Test
    public void observationHasValidLocation() {
        try {
            validator.validate();
        } catch (Exception e) {
            fail("Should have a valid location");
        }
    }

    @Test(expected = ObservationException.class)
    public void observationHasInvalidLocation() {
        observationSet.location.id = 4;
        validator.validate();
    }

}
