package gov.va.vamf.service.clio.observation.representations;

import com.google.common.collect.Lists;
import gov.va.vamf.service.clio.application.representations.*;
import gov.va.vamf.service.clio.observation.ObservationException;
import org.junit.*;

public class ObservationSetTests {

    private ObservationSet observationSet;

    @Before
    public void createValidSet() {
        observationSet = new ObservationSet();

        PersonIdentity nurse = new PersonIdentity("dfn-777", "abc123");

        observationSet.enteredBy = nurse;
        observationSet.enteredDateTime = "2015-02-06@13:17:42";

        Location location = new Location();
        location.id = 1;
        location.name = "One";

        observationSet.location = location;
        observationSet.observationDateTime ="2015-02-06@13:17:42";

        Observation observation = new Observation();
        observation.qualifierIds = Lists.newArrayList(new UniqueTermId("55555", "FIVE_FIVES"));
        observation.uniqueTermId = new UniqueTermId("800", "EIGHT_HUNDRED");
        observation.value = "799";

        observationSet.observations = Lists.newArrayList(observation);
        observationSet.observedBy = nurse;
        observationSet.patient = new PersonIdentity("dfn-777", "8753099");
    }

    @Test(expected = ObservationException.class)
    public void observationSetWithoutLocation() {
        observationSet.location = null;
        observationSet.validate();
    }

    @Test(expected = ObservationException.class)
    public void observationSetWithoutObservations() {
        observationSet.observations = null;
        observationSet.validate();
    }
    @Test(expected = ObservationException.class)
    public void observationSetWitoutEnteredDate() {
        observationSet.enteredDateTime = null;
        observationSet.validate();
    }

    @Test(expected = ObservationException.class)
    public void observationSetWithInvalidEnteredDate() {
        observationSet.enteredDateTime = "3/23/1999@6:00";
        observationSet.validate();
    }

    @Test(expected = ObservationException.class)
    public void observationSetWithInvalidObservationDate() {
        observationSet.observationDateTime = "3/23/1999@6:00";
        observationSet.validate();
    }

    @Test(expected = ObservationException.class)
    public void observationSetWithInvalidEnteredBy() {
        observationSet.enteredBy = new PersonIdentity("", "4567");
        observationSet.validate();
    }

    @Test(expected = ObservationException.class)
    public void observationSetWithInvalidPatient() {
        observationSet.patient = new PersonIdentity("dfn-567", null);
        observationSet.validate();
    }

    @Test(expected = ObservationException.class)
    public void observationWithoutTermId() {
        observationSet.observations.get(0).uniqueTermId = null;
        observationSet.validate();
    }

    @Test(expected = ObservationException.class)
    public void observationWithInvalidTermId() {
        observationSet.observations.get(0).uniqueTermId = new UniqueTermId(null, "MISSING_IN_ACTION");
        observationSet.validate();
    }

    @Test(expected = ObservationException.class)
    public void observationWithoutValue() {
        observationSet.observations.get(0).value = null;
        observationSet.validate();
    }

    @Test(expected = ObservationException.class)
    public void observationWithInvalidValue() {
        observationSet.observations.get(0).value = "";
        observationSet.validate();
    }

    @Test(expected = ObservationException.class)
    public void observationWithInvalidQualifierId() {
        observationSet.observations.get(0).qualifierIds.add(new UniqueTermId("1", ""));
        observationSet.validate();
    }
}
