package gov.va.vamf.service.clio.infrastructure.vista;

import gov.va.vamf.service.clio.infrastructure.vista.ClioResultRecord;
import org.junit.*;
import org.w3c.dom.*;
import org.xml.sax.*;

import javax.xml.parsers.*;
import java.io.*;

import static org.junit.Assert.assertEquals;

public class ClioResultRecordTests {

    private ClioResultRecord resultRecord;

    @Before
    public void init() throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();

        DocumentBuilder builder = builderFactory.newDocumentBuilder();

        Node node = builder.parse(new InputSource(new StringReader("<RECORD><EMPTY></EMPTY><TEXT>Sample Text</TEXT></RECORD>")))
                            .getDocumentElement();

        resultRecord = new ClioResultRecord(node);
    }

    @Test
    public void getDataForNonExistingNode() {
        String data = resultRecord.getString("NONODE");

        assertEquals("", data);
    }

    @Test
    public void getDataForEmptyNode() {
        String data = resultRecord.getString("EMPTY");

        assertEquals("", data);
    }

    @Test
    public void getDataForNode() {
        String data = resultRecord.getString("TEXT");

        assertEquals("Sample Text", data);
    }

    @Test
    public void readFromNullNode() {
        resultRecord = new ClioResultRecord(null);

        String data = resultRecord.getString("TEXT");

        assertEquals("", data);
    }
}
