package gov.va.vamf.service.clio.infrastructure.mdws;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import gov.va.vamf.service.clio.infrastructure.vista.mdws.ClioMessageBuilder;

import java.lang.reflect.Field;

import javax.xml.soap.SOAPMessage;

import org.junit.Before;
import org.junit.Test;

import com.agilex.soap.Message;

public class ClioMessageBuilderTests {
    private ClioMessageBuilder builder;

    @Before
    public void init() {
        builder = new ClioMessageBuilder("123");
    }

    @Test
    public void hasUserToken() throws IllegalAccessException, NoSuchFieldException {
        Message request = builder.build("method");

        Field f = request.getClass().getDeclaredField("message");
        f.setAccessible(true);

        SOAPMessage soapMessage = (SOAPMessage) f.get(request);

        String userToken = soapMessage.getMimeHeaders().getHeader("Cookie")[0];
        String soapAction = soapMessage.getMimeHeaders().getHeader("SOAPAction")[0];

        assertEquals("ASP.NET_SessionId=123", userToken);
        assertEquals("http://DNS   /ClioSvc/executeCLIOCommand", soapAction);
    }

    @Test
    public void hasScriptTestWithoutGuid() {
        Message request = builder.build("method");

        String method = request.getBody()
                                .getChild(new String[]{"executeCLIOCommand", "script"}, "", "http://DNS   /ClioSvc")
                                .getElementValue();

        String command = request.getBody()
                .getChild(new String[]{"executeCLIOCommand", "command"}, "", "http://DNS   /ClioSvc")
                .getElementValue();

        assertEquals("method", method);
        assertEquals("EXECUTE", command);
    }

    @Test
    public void hasGuidWithMultipleParameters() {
        Message request = builder.build("multi-params", "abc", 123);

        String method = request.getBody()
                .getChild(new String[]{"executeCLIOCommand", "script"}, "", "http://DNS   /ClioSvc")
                .getElementValue();

        String command = request.getBody()
                .getChild(new String[]{"executeCLIOCommand", "command"}, "", "http://DNS   /ClioSvc")
                .getElementValue();

        String inputFields = request.getBody()
                .getChild(new String[]{"executeCLIOCommand", "inputFields"}, "", "http://DNS   /ClioSvc")
                .getElementValue();

        
        assertEquals("multi-params", method);
        assertEquals("EXECUTE", command);
        assertEquals("abc^123", inputFields);
    }
}
