package gov.va.vamf.service.clio.observation.validation;

import gov.va.vamf.service.clio.flowsheet.representations.*;
import gov.va.vamf.service.clio.observation.representations.*;
import org.slf4j.*;

/**
 * Root validator for an observation set.
 */
public class ObservationSetValidator implements Validator {
    private static Logger logger = LoggerFactory.getLogger(ObservationSetValidator.class);

    private final ObservationSet observationSet;
    private final Flowsheet flowsheet;

    public ObservationSetValidator(ObservationSet observationSet, Flowsheet flowsheet) {
        this.observationSet = observationSet;
        this.flowsheet = flowsheet;
    }

    @Override
    public void validate() {
        logger.debug("Validating observation set data.");
        observationSet.validate();

        logger.debug("Validating observation set contains a valid location.");
        new LocationValidator(flowsheet, observationSet).validate();

        logger.debug("Validating observation set contains all required observations.");
        new ObsSetIncludeAllRequiredFields(flowsheet.fields, observationSet.observations).validate();

        for (Observation observation : observationSet.observations) {
            new ObservationValidator(observation, flowsheet.fields).validate();
        }
    }
}
