package gov.va.vamf.service.clio.observation.validation;

import gov.va.vamf.service.clio.flowsheet.representations.Flowsheet;
import gov.va.vamf.service.clio.observation.ObservationException;
import gov.va.vamf.service.clio.observation.representations.ObservationSet;

/**
 * Verifies that observation set has a valid location.
 */
public class LocationValidator implements Validator {
    private final Flowsheet flowsheet;
    private final ObservationSet observationSet;

    public LocationValidator(Flowsheet flowsheet, ObservationSet observationSet) {
        this.flowsheet = flowsheet;
        this.observationSet = observationSet;
    }

    @Override
    public void validate() {
        if (!flowsheet.possibleLocations.contains(observationSet.location))
            throw new ObservationException(400, "Observation(s) not saved. An invalid location was provided. Please select a valid location.", "Location was not found in flowsheet with id " + flowsheet.uniqueTermId.id);
    }
}
