package gov.va.vamf.service.clio.observation.representations;

import com.google.common.base.Strings;
import gov.va.vamf.service.clio.application.representations.Namespace;
import gov.va.vamf.service.clio.observation.ObservationException;

import javax.xml.bind.annotation.*;

/**
 * Unique identifier for a person in Vista.  This could be either a nurse or a patient.
 */
@XmlRootElement(name = "person_identity", namespace = Namespace.ns)
public class PersonIdentity {
    /**
     * Should be a Vista assigningAuthority.  Ex: dfn-777.
     */
    @XmlElement()
    public String assigningAuthority;

    /**
     * Unique person id in one Vista system.
     */
    @XmlElement()
    public String uniqueId;

    public PersonIdentity() {}

    public PersonIdentity(String assigningAuthority, String uniqueId) {
        this.assigningAuthority = assigningAuthority;
        this.uniqueId = uniqueId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PersonIdentity that = (PersonIdentity) o;

        return assigningAuthority.equals(that.assigningAuthority) && uniqueId.equals(that.uniqueId);
    }

    @Override
    public int hashCode() {
        return 31 * assigningAuthority.hashCode() + uniqueId.hashCode();
    }

    public void validate() {
        if (Strings.isNullOrEmpty(assigningAuthority) || Strings.isNullOrEmpty(uniqueId))
            throw new ObservationException(400, "Invalid person identity.  Valid assigning authority and unique id required.", "");
    }
}
