package gov.va.vamf.service.clio.infrastructure.vista.mdws;

import com.agilex.soap.*;
import com.google.common.base.Joiner;
import org.slf4j.*;

import javax.xml.soap.SOAPMessage;
import java.lang.reflect.Field;

/**
 * Add a Description.  Should include class purpose (why not what) and assumptions.
 */
public class ClioMessageBuilder {
    private static Logger logger = LoggerFactory.getLogger(ClioMessageBuilder.class);

    private String userToken;

    public ClioMessageBuilder(String userToken) {
        this.userToken = userToken;
    }

    public Message build(String method, Object... parameters) {
        logger.debug("Creating Clio soap message.");

        Message message = new Message();
        message.removeHeader();

        setMimeHeaderValues(message);

        Element bodyElement = message.getBody().addChild("executeCLIOCommand", "", "http://mdws.DNS   /ClioSvc");

        bodyElement.addChild("script", "", "http://DNS   /ClioSvc").addElementValue(method);
        bodyElement.addChild("command", "", "http://DNS   /ClioSvc").addElementValue("EXECUTE");
        Element guid = bodyElement.addChild("inputFields", "", "http://DNS   /ClioSvc");

        if (parameters != null && parameters.length > 0) {
            Joiner joiner  = Joiner.on("^").skipNulls();
            guid.addElementValue(joiner.join(parameters));
        }

        logger.debug("Clio soap message sent: " + message.toString());

        return message;
    }

    //This is a work-around because SoapLib is not currently independently deplorable.  Code has been added to
    //SoapLib to support setting MimeHeader values.
    private void setMimeHeaderValues(Message message) {
        try {
            Field f = message.getClass().getDeclaredField("message");
            f.setAccessible(true);
            SOAPMessage soapMessage = (SOAPMessage) f.get(message);
            soapMessage.getMimeHeaders().addHeader("Cookie", "ASP.NET_SessionId=" + userToken);
            soapMessage.getMimeHeaders().addHeader("Content-Type", "text/xml");
            soapMessage.getMimeHeaders().addHeader("SOAPAction", "http://DNS   /ClioSvc/executeCLIOCommand");
        } catch (NoSuchFieldException e) {
            throw new ClioMdwsException("Unable to add mime header value.  Wrong SOAP library in class path.");
        } catch (IllegalAccessException e) {
            throw new ClioMdwsException("Unable to add mime header value. Security on server prevents mime header access.");
        }
    }
}
