package gov.va.vamf.service.clio.infrastructure.vista.mdws;

import gov.va.vamf.service.clio.infrastructure.vista.ClioResultRecords;
import gov.va.vamf.service.clio.infrastructure.vista.VistaService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.agilex.soap.Fault;
import com.agilex.soap.Message;
import com.agilex.soap.Service;
import com.google.common.base.Throwables;

/**
 * Is thread safe but token may not be valid anymore ie user has logged out so a new instance of this class should be
 * created when needed.
 */
public class ClioMdwsService implements VistaService {
    private static Logger logger = LoggerFactory.getLogger(ClioMdwsService.class);

    private final String token;
    private final String mdwsUrl;
    private final int connectionTimeout;
    private final int readTimeout;

    public ClioMdwsService(String token, String mdwsUrl, int connectionTimeout, int readTimeout) {
        this.token = token;
        this.mdwsUrl = mdwsUrl;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }

    @Override
    public ClioResultRecords makeClioCall(String method, Object... parameters) {
        Service service = new Service(mdwsUrl, connectionTimeout, readTimeout);

        ClioMessageBuilder requestBuilder = new ClioMessageBuilder(token);

        Message response;

        try {
            Message request = requestBuilder.build(method, parameters);
            response = request.send(service);
        } catch (Throwable e) {
            logger.error("Error making clio mdws call for method " + method, e);
            throw new ClioMdwsException("Error executing " + method + ". Operation did not complete successfully. (" +
                    Throwables.getRootCause(e).toString() + ") " + Throwables.getRootCause(e).getMessage());
        }

        if (response.getBody().hasFault()) {
            Fault fault = response.getBody().getFault();
            logger.error("Error making clio mdws call for method " + method + ". Mdws returned a Soap fault. Fault: " + fault.getFaultReason());
            throw new ClioMdwsException("Error executing " + method + ". Operation did not complete successfully. " + fault.getFaultReason());
        }

        return ClioResultRecords.fromSoapMessage(response);
    }
}
