package gov.va.vamf.service.clio.infrastructure.vista;

import gov.va.vamf.service.clio.application.config.ClioFlowsheetsConfig;
import gov.va.vamf.service.clio.infrastructure.security.UserServices;
import gov.va.vamf.service.clio.infrastructure.vista.mdws.ClioMdwsService;

/**
 * Add a Description.  Should include class purpose (why not what) and assumptions.
 */
public class VistaServiceFactory {
    private static ClioFlowsheetsConfig config;

    public static void init(ClioFlowsheetsConfig clioFlowsheetsConfig) {
        config = clioFlowsheetsConfig;
    }

    public VistaService get(String assigningAuthority) {
         return createMdwsService();
    }

    private VistaService createMdwsService() {
    	UserServices userServices = new UserServices();
        String token = userServices.getUserMdwsSessionId();
        String mdwsBaseUrl = userServices.getMdwsBaseUrl();
        
        String mdwsUrl = null;
        
        // This code is added to use mock CLIO service based on mockClioUrl config parameter
        if (config.mockClioMdwsUrl() == null || "".equalsIgnoreCase(config.mockClioMdwsUrl())){
        	mdwsUrl = mdwsBaseUrl + "/" + config.clioMdwsUrl();
        }else{
        	mdwsUrl = config.mockClioMdwsUrl();
        }
        		

        return new ClioMdwsService(token, mdwsUrl, config.mdwsConnectionTimeOut(), config.mdwsReadTimeOut());
    }
}
