package gov.va.vamf.service.clio.infrastructure.vista;

import org.slf4j.*;
import org.w3c.dom.Node;

import javax.xml.xpath.*;

public class ClioResultRecord {
    private static Logger logger = LoggerFactory.getLogger(ClioResultRecord.class);

    private final Node node;
    private final XPath xPath =  XPathFactory.newInstance().newXPath();

    public ClioResultRecord(Node node) {
        this.node = node;
    }

    public String getString(String key) {
        try {
            return (String) xPath.compile(key + "/text()").evaluate(node, XPathConstants.STRING);
        } catch (XPathExpressionException e) {
            logger.error("Error reading data from " + key + " node.", e);
        } catch (ClassCastException ec) {
            logger.error("Error casting data from " + key + " node to String.", ec);
        }

        return "";
    }

    public Integer getInteger(String key) {
        try {
            return ((Double) xPath.compile(key + "/text()").evaluate(node, XPathConstants.NUMBER)).intValue();
        } catch (XPathExpressionException e) {
            logger.error("Error reading data from " + key + " node.", e);
        } catch (ClassCastException ec) {
            logger.error("Error casting data from " + key + " node to Double.", ec);
        }

        return 0;
    }

    public Float getFloat(String key) {
        try {
             return ((Double) xPath.compile(key + "/text()").evaluate(node, XPathConstants.NUMBER)).floatValue();
        } catch (XPathExpressionException e) {
            logger.error("Error reading data from " + key + " node.", e);
        } catch (ClassCastException ec) {
            logger.error("Error casting data from " + key + " node to Double.", ec);
        }

        return (float) 0;
    }

    public long getLong(String key) {
        try {
            return ((Double) xPath.compile(key + "/text()").evaluate(node, XPathConstants.NUMBER)).longValue();
        } catch (XPathExpressionException e) {
            logger.error("Error reading data from " + key + " node.", e);
        } catch (ClassCastException ec) {
            logger.error("Error casting data from " + key + " node to Double.", ec);
        }

        return (long) 0;
    }
}
