package gov.va.vamf.service.clio.infrastructure.security;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;
import com.google.common.base.Strings;

/**
 * Wrapper around mphUser.  Is thread safe.
 */
public class UserServices {

    public String getAssigningAuthority() {
        try {
            return user().getUserIdentifier().getAssigningAuthority();
        } catch (Exception e) {
            throw createException(e);
        }
    }

    public String getUniqueId() {
        try {
            return user().getUserIdentifier().getUniqueId();
        } catch (Exception e) {
            throw createException(e);
        }
    }

    public String getUserMdwsSessionId() {
        String sessionId;

        try {
            sessionId = user().getMdwsInfo().getSessionId();
        } catch (NullPointerException e) {
            throw createException(e);
        }

        if (Strings.isNullOrEmpty(sessionId))
            throw createException(null);
        else
            return sessionId;
    }

    public String getMdwsBaseUrl() {
        String mdwsBaseUrl;

        try {
        	mdwsBaseUrl = user().getMdwsInfo().getBaseUrl();
        } catch (NullPointerException e) {
            throw createException(e);
        }

        if (Strings.isNullOrEmpty(mdwsBaseUrl))
            throw createException(null);
        else
            return mdwsBaseUrl;
    }
 
    private MhpUser user() {
        return MhpUserFactory.createFromSecurityContext();
    }

    private UserServicesException createException(Throwable e) {
        if (e == null)
            return new UserServicesException("Unable to complete request. Unable to get user session id for Mdws.");
        else
            return new UserServicesException("Unable to complete request. Unable to get user session id for Mdws.", e);
    }
}