package gov.va.vamf.service.clio.flowsheet.representations;

import com.google.common.base.Objects;
import gov.va.vamf.service.clio.application.representations.*;

import javax.xml.bind.annotation.*;

/**
 * Represents a single value from clio.  It could be either be part of the identification of a field or represent a
 * single possible value for a field. Ex: pick list value or boolean value.
 */
@XmlRootElement(name = "value", namespace = Namespace.ns)
public class Value {

    /**
     * Contains the Clio generated unique id for an field or value as well as its canonical name.  If it a boolean
     * value it will have an id of zero for false and an id of one for true.
     */
    @XmlElement(required = true)
    public UniqueTermId uniqueTermId;

    /**
     * Text to display for the field or value.
     */
    @XmlElement(required = true)
    public String displayText;

    /**
     * Optional additional information about the field or value.
     */
    @XmlElement()
    public String description;

    /**
     * Optional help text to display to the user.
     */
    @XmlElement()
    public String helpText;

    public Value() {}

    public Value(UniqueTermId uniqueTermId) {
        this.uniqueTermId = uniqueTermId;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper(this).omitNullValues()
                .add("id", uniqueTermId.id)
                .add("display text", displayText)
                .add("description", description)
                .add("help text", helpText)
                .toString();
    }
}
