package gov.va.vamf.service.clio.flowsheet.representations;

import com.google.common.base.Objects;

/**
 * Represents a Unit of Measure value that provides additional data to support field validation.
 */
public class Unit extends Value {
    /**
     * Minimum possible value for a value in this Unit of Measure.
     */
    public float min;

    /**
     * Maximum possible value for a value in this Unit of Measure.
     */
    public float max;

    /**
     * Number of decimal places of precision supported for this Unit of Measure. Zero for this value means the Unit of
     * Measure does support any decimal values only whole numbers (Integers).
     * Examples: 1 would support numeric values like 2.4 and 0.3.
     *           2 would support numeric values like 3.14 and 3243.34.
     */
    public int precision;

    @Override
    public String toString() {
        return Objects.toStringHelper(this).omitNullValues()
                .add("min", min)
                .add("max", max)
                .add("precision", precision)
                .toString();
    }
}
