package gov.va.vamf.service.clio.flowsheet.representations;

import com.google.common.collect.Lists;
import gov.va.vamf.service.clio.application.representations.*;
import gov.va.vamf.service.clio.application.resources.Routes;

import javax.xml.bind.annotation.*;
import java.util.*;

/**
 * Representation that holds a collection of FlowsheetItem.
 */
@XmlRootElement(name = "flowsheet_items", namespace = Namespace.ns)
public class FlowsheetList {
    /**
     *  Collection of zero or more FlowsheetItems.
     */
    @XmlElement()
    public List<FlowsheetItem> flowsheetItems = Lists.newArrayList();

    /**
     * Returns related resources.
     * Titles ares: get-flowsheet-list.
     */
    @XmlElement(name = "link", required = true)
    public List<Link> links = Lists.newArrayList();

    public FlowsheetItem find(String flowsheetId) {
        for (FlowsheetItem item : flowsheetItems) {
            if (item.uniqueTermId.id.equals(flowsheetId))
                return item;
        }

        return null;
    }

    public void generateLinks(Routes routes) {
        if (links.size() > 0 )
            return;

        Link selfLink = routes.getFlowsheetList();
        selfLink.rel = Link.self;

        links.add(selfLink);

        for (FlowsheetItem item : flowsheetItems)
            item.generateLinks(routes);
    }
}
