package gov.va.vamf.service.clio.flowsheet.representations;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import gov.va.vamf.service.clio.application.representations.*;
import gov.va.vamf.service.clio.application.resources.Routes;

import javax.xml.bind.annotation.*;
import java.util.*;

/**
 * Used to provide a list of flowsheet names and a link to get the flowsheet data entry data.
 *
 * Note for Nurse Companion application developers:  Save the flowsheet name and link in the NewScheduledTask
 * representation's name and externalTaskUrl fields respectively.
 */
@XmlRootElement(name = "flowsheet_item", namespace = Namespace.ns)
public class FlowsheetItem {
    /**
     * Contains the flowsheet id and display name.
     */
    @XmlElement(required = true)
    public UniqueTermId uniqueTermId;

    /**
     * Holds a comment if one was added when the flowsheet was create.
     */
    @XmlElement()
    public String comment;

    /**
     * Resource id for flowsheet.
     */
    @XmlElement()
    public String resourceId;

    @XmlElement(name = "link", required = true)
    public List<Link> links = Lists.newArrayList();

    public FlowsheetItem() {}

    public FlowsheetItem(UniqueTermId uniqueTermId) {
        this.uniqueTermId = uniqueTermId;
    }

    public void generateLinks(Routes routes) {
        if (links.size() > 0)
            return;

        resourceId = CharMatcher.anyOf("{}").removeFrom(uniqueTermId.id);
        links.add(routes.getFlowsheet(resourceId));
    }
}
