package gov.va.vamf.service.clio.flowsheet.representations;

import com.google.common.base.Objects;
import com.google.common.collect.*;
import gov.va.vamf.service.clio.application.representations.*;

import javax.xml.bind.annotation.*;
import java.util.List;

/**
 * Represents a single data entry element including label, help text and any possible values for the field.
 */
@XmlRootElement(name = "field", namespace = Namespace.ns)
public class Field extends Value {
    /**
     * Data type for field.  Valid values are String, Numeric, Boolean and PickList.
     */
    @XmlElement(required = true)
    public String dataType;

    /**
     * One or more possible values for PickList or Boolean dataTypes only.
     */
    @XmlElement()
    public List<Value> possibleValues = Lists.newArrayList();

    /**
     * True if the dataType is Picklist and multiple values may be selected from the list of possible values.
     * Otherwise it is false.
     */
    @XmlElement(required = true)
    public boolean multiSelect;

    /**
     * True if the field or qualifier is required when submitting results for write back to Vista.
     * Otherwise it is false.
     */
    @XmlElement(required = true)
    public boolean required;

    /**
     * Id of value that should be shown in a PickList by default if one was specified.
     */
    @XmlElement()
    public UniqueTermId defaultValueId;

    /**
     *  Zero or more fields that contain either read only information and/ or data entry fields that modify this field.
     *  Possible values are Location, Units, Method, Position, Product, Task, Schedule or Quality.
     *  Ex.: Picklist of possible units or read only location of blood pressure reading.
     */
    @XmlElement()
    public List<Field> qualifiers = Lists.newArrayList();

    @Override
    public String toString() {
        return Objects.toStringHelper(this).omitNullValues()
                .add("data type", dataType)
                .add("required", required)
                .add("multi-select", multiSelect)
                .add("default value id", defaultValueId)
                .add("qualifiers", Iterables.toString(qualifiers))
                .toString();
    }
}