package gov.va.vamf.service.clio.flowsheet.cache.location;

import gov.va.vamf.service.clio.application.representations.*;
import gov.va.vamf.service.clio.flowsheet.cache.*;

import java.util.List;

/**
 * Static cache for possible locations to save observations.  Key value is the Vista facility's assigning authority.
 *
 * @see gov.va.vamf.service.clio.flowsheet.cache.ClioCache
 */
public class LocationsCache extends ClioCache<CacheKey<String>, List<Location>> {
    private static LocationsCache cache;

    public synchronized static LocationsCache getInstance(Loader loader) {
        if (cache == null)
            cache = new LocationsCache(loader);

        return cache;
    }

    //for testing????
    public static void clearCache() {
        cache = null;
    }

    protected LocationsCache(Loader loader) {
        super(loader);
    }
}
