package gov.va.vamf.service.clio.flowsheet.cache.flowsheet.handlers;

import com.google.common.eventbus.*;
import gov.va.vamf.service.clio.flowsheet.cache.flowsheet.events.ValueFound;
import gov.va.vamf.service.clio.flowsheet.representations.Value;
import gov.va.vamf.service.clio.infrastructure.security.UserServices;
import gov.va.vamf.service.clio.infrastructure.vista.*;
import gov.va.vamf.service.clio.infrastructure.vista.mdws.ClioMdwsService;
import org.slf4j.*;

/**
 * Retrieves details about a specific term from Clio.  This handle is used to get details for units and possible values
 * for pick lists (fields and qualifiers).
 */
public class GetValueDetailsHandler extends DetailHandler<Value> {
    private static Logger logger = LoggerFactory.getLogger(GetValueDetailsHandler.class);

    public GetValueDetailsHandler(EventBus bus, VistaService vistaService) {
        super(bus, vistaService);
    }

    @Subscribe
    public void handle(ValueFound event) {
        logger.debug("Getting value details with id {}.", event.value.uniqueTermId.id);

        handle(event.value);
    }

    @Override
    protected void addAdditionalData(Value value, ClioResultRecord clioResultRecord) {
        //nothing to do
    }
}