package gov.va.vamf.service.clio.flowsheet.cache.flowsheet.handlers;

import com.google.common.base.Optional;
import com.google.common.eventbus.*;
import gov.va.vamf.service.clio.flowsheet.cache.flowsheet.events.*;
import gov.va.vamf.service.clio.flowsheet.representations.*;
import gov.va.vamf.service.clio.infrastructure.security.UserServices;
import gov.va.vamf.service.clio.application.representations.UniqueTermId;
import gov.va.vamf.service.clio.infrastructure.vista.*;
import gov.va.vamf.service.clio.infrastructure.vista.mdws.ClioMdwsService;
import org.slf4j.*;

/**
 * Used to get units for a field. Should only be executed for fields with a data type
 * of Numeric.
 */
public class GetUnitsHandler  extends FlowsheetsHandler {
    private static Logger logger = LoggerFactory.getLogger(GetUnitsHandler.class);

    public GetUnitsHandler(EventBus bus, VistaService vistaService) {
        super(bus, vistaService);
    }

    @Subscribe
    public void handle(FieldHasPossibleUnits event) {
        logger.debug("Getting possible unit values for field with id {}.", event.field.uniqueTermId.id);

        Optional<ClioResultRecords> result = getClioData("GetTermUnitPairsByID", event.field.uniqueTermId.id);

        if (!result.isPresent())
            return;

        ClioResultRecords resultRecords = result.get();

        while (resultRecords.hasNext()) {
            ClioResultRecord resultRecord = resultRecords.next();

            Unit unit = new Unit();
            unit.uniqueTermId = new UniqueTermId(resultRecord.getString("UNIT_ID"), resultRecord.getString("UNIT_NAME"));
            unit.max = resultRecord.getFloat("MAX_VALUE");
            unit.min = resultRecord.getFloat("MIN_VALUE");
            unit.precision = resultRecord.getInteger("DEC_PRECISION");

            if (getValueDetails(event.field, unit)) {
                event.field.possibleValues.add(unit);

                ValueFound valueFound = new ValueFound(unit);
                bus.post(valueFound);
            }
        }
    }

    //If qualifier has required field then only want to load the single value (specified in default value) into the
    //the list of possible values.
    private boolean getValueDetails(Field field, Value value) {
        return field.defaultValueId == null || !field.required || field.defaultValueId.id.equals(value.uniqueTermId.id);
    }
}
