package gov.va.vamf.service.clio.flowsheet.cache.flowsheet.handlers;

import com.google.common.base.Optional;
import com.google.common.eventbus.*;
import gov.va.vamf.service.clio.flowsheet.cache.flowsheet.events.*;
import gov.va.vamf.service.clio.flowsheet.representations.*;
import gov.va.vamf.service.clio.infrastructure.security.UserServices;
import gov.va.vamf.service.clio.application.representations.UniqueTermId;
import gov.va.vamf.service.clio.infrastructure.vista.*;
import gov.va.vamf.service.clio.infrastructure.vista.mdws.ClioMdwsService;
import org.slf4j.*;

/**
 * Retrieves a list of possible values for a field or qualifier.  Should only be executed for fields with a data type
 * of PickList.
 */
public class GetPossibleValuesHandler extends FlowsheetsHandler {
    private static Logger logger = LoggerFactory.getLogger(GetPossibleValuesHandler.class);

    public GetPossibleValuesHandler(EventBus bus, VistaService vistaService) {
        super(bus, vistaService);
    }

    @Subscribe
    public void handle(FieldHasPossibleValues event) {
        logger.debug("Getting possible values for field with id {}.", event.field.uniqueTermId.id);

        Optional<ClioResultRecords> result = getClioData("GetTermQualifierPairsByID", event.field.uniqueTermId.id, event.termType);

        if (!result.isPresent())
            return;

        ClioResultRecords resultRecords = result.get();

        while (resultRecords.hasNext()) {
            Value value = new Value(new UniqueTermId(resultRecords.next().getString("QUALIFIER_ID"), ""));

            if (getValueDetails(event.field, value)) {
                event.field.possibleValues.add(value);

                ValueFound valueFound = new ValueFound(value);
                bus.post(valueFound);
            }
        }
    }

    //If qualifier has required field then only want to load the single value (specified in default value) into the
    //the list of possible values.
    private boolean getValueDetails(Field field, Value value) {
        return field.defaultValueId == null || !field.required || field.defaultValueId.id.equals(value.uniqueTermId.id);
    }
}
