package gov.va.vamf.service.clio.flowsheet.cache.flowsheet.handlers;

import com.google.common.base.Optional;
import com.google.common.eventbus.*;
import gov.va.vamf.service.clio.flowsheet.cache.flowsheet.FlowsheetRequestedCommand;
import gov.va.vamf.service.clio.flowsheet.cache.flowsheet.events.FlowsheetViewFound;
import gov.va.vamf.service.clio.infrastructure.security.UserServices;
import gov.va.vamf.service.clio.infrastructure.vista.*;
import gov.va.vamf.service.clio.infrastructure.vista.mdws.ClioMdwsService;
import org.slf4j.*;

/**
 * A flowsheet is made up of one or views of data.  This handler is used to retrieve the views for a flowsheet.
 */
public class GetFlowsheetViewsHandler extends FlowsheetsHandler {
    private static Logger logger = LoggerFactory.getLogger(GetFlowsheetViewsHandler.class);

    public GetFlowsheetViewsHandler(EventBus bus, VistaService vistaService) {
        super(bus, vistaService);
    }

    @Subscribe
    public void handle(FlowsheetRequestedCommand event) {
        logger.debug("Getting views for flowsheet with id {}.", event.flowsheet.uniqueTermId.id);

        Optional<ClioResultRecords> result = getClioData("GetFlowsheetPageList", event.flowsheet.uniqueTermId.id);

        if (!result.isPresent())
            return;

        ClioResultRecords resultRecords = result.get();

        while (resultRecords.hasNext()) {
            FlowsheetViewFound viewFound = new FlowsheetViewFound(event.flowsheet, resultRecords.next().getString("VIEW_ID"));
            bus.post(viewFound);
        }
    }
}
