package gov.va.vamf.service.clio.flowsheet.cache.flowsheet.handlers;

import com.google.common.base.Optional;
import com.google.common.eventbus.*;
import gov.va.vamf.service.clio.flowsheet.cache.flowsheet.events.*;
import gov.va.vamf.service.clio.infrastructure.security.UserServices;
import gov.va.vamf.service.clio.application.representations.UniqueTermId;
import gov.va.vamf.service.clio.flowsheet.representations.Field;
import gov.va.vamf.service.clio.infrastructure.vista.*;
import gov.va.vamf.service.clio.infrastructure.vista.mdws.ClioMdwsService;
import org.slf4j.*;

/**
 * Add a Description.  Should include class purpose (why not what) and assumptions.
 */
public class GetFlowsheetViewTermsHandler extends FlowsheetsHandler {
    private static Logger logger = LoggerFactory.getLogger(GetFlowsheetViewTermsHandler.class);

    public GetFlowsheetViewTermsHandler(EventBus bus, VistaService vistaService) {
        super(bus, vistaService);
    }

    @Subscribe
    public void handle(FlowsheetViewFound event) {
        logger.debug("Getting terms for view with id {}.", event.viewId);

        Optional<ClioResultRecords> result = getClioData("GetFlowsheetViewTerms", event.viewId);

        if (!result.isPresent())
            return;

        ClioResultRecords resultRecords = result.get();

        while (resultRecords.hasNext()) {
            ClioResultRecord resultRecord = resultRecords.next();

            Field field = new Field();
            field.uniqueTermId = new UniqueTermId(resultRecord.getString("TERM_ID"), "");
            field.displayText = resultRecord.getString("DISPLAY_NAME");
            field.required = resultRecord.getInteger("REQUIRED_TERM") == 1;

            event.flowsheet.fields.add(field);

            FieldFound fieldFound = new FieldFound(field);
            bus.post(fieldFound);
        }

        bus.post(new ViewFieldsFound(event));
    }
}
