package gov.va.vamf.service.clio.flowsheet.cache.flowsheet.handlers;

import com.google.common.base.*;
import com.google.common.eventbus.EventBus;
import gov.va.vamf.service.clio.infrastructure.vista.*;
import gov.va.vamf.service.clio.infrastructure.vista.mdws.ClioMdwsService;
import org.slf4j.*;

import java.util.concurrent.TimeUnit;

/**
 * This is the base handler for all handlers that use a VistaService to retrieve flowsheet data.
 */
public class FlowsheetsHandler {
    private static Logger logger = LoggerFactory.getLogger(FlowsheetsHandler.class);

    protected final EventBus bus;
    private final VistaService vistaService;

    private Stopwatch stopwatch = null;

    public FlowsheetsHandler(EventBus bus, VistaService vistaService) {
        this.bus = bus;
        this.vistaService = vistaService;
    }

    public Optional<ClioResultRecords> getClioData(String method, Object... parameters) {
        debugLogWithStartTimer(method);

        try {
            return Optional.fromNullable(vistaService.makeClioCall(method, parameters));
        } catch (Exception e) {
            logger.error("Error retrieving data from vista service for method {}.", method);
            bus.post(e);
        }

        debugLogWithElapsedTime(method);

        return Optional.absent();
    }

    public void debugLogWithStartTimer(String method) {
        if (logger.isDebugEnabled()) {
            logger.debug("Vista service clio call for " + method);
            stopwatch = Stopwatch.createStarted();
        }
    }

    public void debugLogWithElapsedTime(String method) {
        if (logger.isDebugEnabled() && stopwatch != null) {
            stopwatch.stop();
            logger.debug("Vista service clio call for " + method + " completed in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " milliseconds.");
        }
    }
}
