package gov.va.vamf.service.clio.flowsheet.cache.flowsheet;

import gov.va.vamf.service.clio.flowsheet.cache.*;
import gov.va.vamf.service.clio.flowsheet.representations.*;

/**
 * Static cache for List of Flowsheets.  Key is the Vista facility's assigning authority.
 *
 * @see gov.va.vamf.service.clio.flowsheet.cache.ClioCache
 */
public class FlowsheetListCache extends ClioCache<CacheKey<String>, FlowsheetList> {
    private static FlowsheetListCache cache;

    public synchronized static FlowsheetListCache getInstance(Loader loader) {
        if (cache == null)
            cache = new FlowsheetListCache(loader);

        return cache;
    }

    //for testing????
    public static void clearCache() {
        cache = null;
    }

    protected FlowsheetListCache(Loader loader) {
        super(loader);
    }
}
