package gov.va.vamf.service.clio.flowsheet.cache.flowsheet;

import gov.va.vamf.service.clio.flowsheet.cache.*;
import gov.va.vamf.service.clio.flowsheet.representations.*;

/**
 * Static cache for Flowsheets.  Key is the flowsheet's unique id.  This cache will contain flowsheets from all Vistas
 * since the flowsheet unique id is a GUID aka should be globally unique.
 *
 * Loading a single flowsheet involves several calls to Vista using Mdws.
 *
 * @see gov.va.vamf.service.clio.flowsheet.cache.ClioCache
 */
public class FlowsheetCache extends ClioCache<CacheKey<FlowsheetItem>, Flowsheet> {
    private static FlowsheetCache cache;

    public synchronized static FlowsheetCache getInstance(Loader loader) {
        if (cache == null)
            cache = new FlowsheetCache(loader);

        return cache;
    }

    //for testing????
    public static void clearCache() {
        cache = null;
    }

    protected FlowsheetCache(Loader loader) {
        super(loader);
    }
}
