package gov.va.vamf.service.clio.flowsheet.cache;

import gov.va.vamf.service.clio.flowsheet.cache.flowsheet.*;
import gov.va.vamf.service.clio.flowsheet.cache.location.*;
import gov.va.vamf.service.clio.flowsheet.representations.*;
import gov.va.vamf.service.clio.infrastructure.security.UserServices;
import gov.va.vamf.service.clio.infrastructure.vista.*;
import gov.va.vamf.service.clio.infrastructure.vista.mdws.ClioMdwsService;

/**
 * Flowsheet application service interface used by Resources to get flowsheet data.
 */
public class FlowsheetService {
    private final VistaService service;

    public FlowsheetService(VistaService service) {
        this.service = service;

    }
    public FlowsheetList getFlowsheetList(String assigningAuthority) {
        CacheKey<String> key = new CacheKey<String>(assigningAuthority, service);

        return FlowsheetListCache.getInstance(new FlowsheetItemsLoader())
                                .get(key);
    }

    public Flowsheet getFlowsheet(String assigningAuthority, String flowsheetId) {

        FlowsheetList items = getFlowsheetList(assigningAuthority);

        FlowsheetItem item = items.find(flowsheetId);

        if (item == null)
            throw new FlowsheetException(400, "Unable to find flowsheet in the list of flowsheets for this facility.", "Item not in Flowsheet List.");

        CacheKey<FlowsheetItem> flowsheetKey = new CacheKey<FlowsheetItem>(item, service);
        Flowsheet flowsheet = FlowsheetCache.getInstance(new FlowsheetRetrievalExecutive())
                .get(flowsheetKey);

        CacheKey<String> locationKey = new CacheKey<String>(assigningAuthority, service);
        flowsheet.possibleLocations = LocationsCache.getInstance(new LocationsLoader())
                                                    .get(locationKey);

        return flowsheet;
    }
}
