package gov.va.vamf.service.clio.flowsheet.cache;

import gov.va.vamf.service.clio.infrastructure.vista.VistaService;

/**
 * This is a generic key used to get data from caches.  It includes a value (T) and a VistaService interface.
 *
 * The VistaService interface is used by the Loader to get data.  VistaService instances will contain thread specific
 * information such as a user's mdws token which are only valid for a short period of time i.e. any state information.
 *
 * Loaders should be thread safe and contain no state.
 *
 * @see gov.va.vamf.service.clio.infrastructure.vista.VistaService
 */
public class CacheKey<T> {
    public T value;
    public VistaService vistaService;

    public CacheKey(T value, VistaService vistaService) {
        this.value = value;
        this.vistaService = vistaService;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CacheKey cacheKey = (CacheKey) o;

        return !(value != null ? !value.equals(cacheKey.value) : cacheKey.value != null);

    }

    @Override
    public int hashCode() {
        return value != null ? value.hashCode() : 0;
    }
}
